/* m3u8 batch generator + progress UI (for AList)
 *
 * 功能：
 * 1) 生成过程显示明确进度/日志（不再只有转圈）
 * 2) 支持多选批量生成（顺序执行，稳定）
 * 3) “已生成”严格禁止重复生成：后端返回 exists=1 时直接跳过并提示必须先删除旧链接
 *
 * 使用方式：
 * - 将本文件保存为：public/static/admin/js/m3u8_fix.js
 * - 在 application/admin/view/public/copy.html 中 copy.js 之后引入：
 *     <script src="__JS__/m3u8_fix.js?v={$version.code}"></script>
 */
(function () {
  if (typeof window === 'undefined' || !window.layui || !layui.$) return;

  var $ = layui.$;
  var layer = layui.layer;

  // 保留原函数（非 alist 或你想回退时可用）
  var oldM3u8Link = window.M3u8Link;

  function getEntryPhp() {
    // /12345.php/xxx/yyy => /12345.php 
    var m = location.pathname.match(/\/[^\/]+\.php/);
    return m ? m[0] : '/12345.php';
	// 填写修改后的后台 amin.php 真实文件名
  }

  function esc(s) {
    return String(s == null ? '' : s)
      .replace(/&/g, '&amp;')
      .replace(/</g, '&lt;')
      .replace(/>/g, '&gt;')
      .replace(/"/g, '&quot;')
      .replace(/'/g, '&#39;');
  }

  function openProgress(total) {
    var html =
      '<div style="padding:12px;">' +
        '<div id="m3u8_fix_title" style="font-size:14px;line-height:20px;margin-bottom:8px;">准备生成...</div>' +
        '<div style="height:10px;background:#f2f2f2;border-radius:6px;overflow:hidden;">' +
          '<div id="m3u8_fix_bar" style="height:10px;width:0%;background:#16b777;"></div>' +
        '</div>' +
        '<div style="margin-top:8px;display:flex;justify-content:space-between;align-items:center;">' +
          '<div id="m3u8_fix_counter" style="color:#666;">0/0</div>' +
          '<div>' +
            '<button class="layui-btn layui-btn-sm layui-btn-primary" id="m3u8_fix_stop">停止</button>' +
            '<button class="layui-btn layui-btn-sm" id="m3u8_fix_copy_success">复制成功链接</button>' +
          '</div>' +
        '</div>' +
        '<pre id="m3u8_fix_log" style="margin-top:10px;background:#0b1020;color:#c9d1d9;padding:10px;border-radius:8px;max-height:260px;overflow:auto;font-size:12px;line-height:1.4;"></pre>' +
      '</div>';

    var idx = layer.open({
      type: 1,
      title: '批量生成 m3u8 链接',
      area: ['860px', '420px'],
      shadeClose: false,
      content: html
    });

    return idx;
  }

  function setBar(pct) {
    $('#m3u8_fix_bar').css('width', Math.max(0, Math.min(100, pct)) + '%');
  }
  function setTitle(t) { $('#m3u8_fix_title').text(t); }
  function setCounter(cur, total) { $('#m3u8_fix_counter').text(cur + '/' + total); }
  function logLine(text) {
    var $log = $('#m3u8_fix_log');
    var now = new Date();
    var ts = now.toLocaleTimeString();
    $log.append('[' + ts + '] ' + text + '\n');
    $log.scrollTop($log[0].scrollHeight);
  }

  function copyText(text) {
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(text);
      return;
    }
    var $tmp = $('<textarea style="position:fixed;left:-9999px;top:-9999px;"></textarea>').val(text).appendTo('body');
    $tmp[0].select();
    document.execCommand('copy');
    $tmp.remove();
  }

  function buildPayload(row, userId) {
    return {
      userId: userId,
      panType: 'alist',
      root_path: row.root_path || '',
      path: row.path || '',
      parentName: row.fileName || row.parentName || row.name || 'folder',
      // 如果列表行里有 32位 md5 的 fileId，优先用它保证与旧系统一致
      parentId: (row.fileId && /^[a-f0-9]{32}$/i.test(row.fileId)) ? row.fileId : ''
    };
  }

  function isDir(row) {
    return !!(row && (row.is_dir === true || row.is_dir === 1 || row.is_dir === '1'));
  }

  window.M3u8Link = function (data, panType) {
    panType = String(panType || '').toLowerCase();

    // 只接管 alist，其他盘回退原逻辑
    if (panType !== 'alist') {
      return typeof oldM3u8Link === 'function' ? oldM3u8Link(data, panType) : undefined;
    }

    // data 是 layui table checkStatus.data（数组），页面通常会额外设置 data.id = maopan.account_id
    if (!data || !data.length) {
      layer.alert('请先勾选至少一个文件夹', { icon: 2 });
      return;
    }

    var userId = data.id || 0;
    if (!userId) {
      layer.alert('缺少账号ID（userId）。请检查页面是否有 data.id = maopan.account_id', { icon: 2 });
      return;
    }

    // 过滤出文件夹
    var rows = [];
    for (var i = 0; i < data.length; i++) {
      if (isDir(data[i])) rows.push(data[i]);
    }
    if (!rows.length) {
      layer.alert('只能对“文件夹”生成 m3u8，请重新选择', { icon: 2 });
      return;
    }

    var total = rows.length;
    var layerIdx = openProgress(total);
    var stop = false;
    var successLinks = [];

    setTitle('准备生成...');
    setCounter(0, total);
    setBar(0);
    logLine('选择文件夹数：' + total);

    $('#m3u8_fix_stop').off('click').on('click', function () {
      stop = true;
      logLine('已请求停止，当前任务完成后终止。');
      $(this).prop('disabled', true).text('已停止');
    });

    $('#m3u8_fix_copy_success').off('click').on('click', function () {
      if (!successLinks.length) return layer.msg('暂无成功链接');
      copyText(successLinks.join('\n'));
      layer.msg('已复制 ' + successLinks.length + ' 条成功链接');
    });

    var api = getEntryPhp() + '/m3u8fix/create';

    function next(idx) {
      if (stop) {
        setTitle('已停止');
        logLine('任务停止。成功：' + successLinks.length + ' / ' + total);
        setBar(Math.round((idx / total) * 100));
        return;
      }

      if (idx >= total) {
        setTitle('全部完成');
        setCounter(total, total);
        setBar(100);
        logLine('全部完成。成功：' + successLinks.length + ' / ' + total);
        return;
      }

      var row = rows[idx];
      var name = row.fileName || row.parentName || row.name || ('folder-' + (idx + 1));

      setTitle('处理中：' + name);
      setCounter(idx + 1, total);
      setBar(Math.round((idx / total) * 100));
      logLine('开始生成 [' + (idx + 1) + '/' + total + ']：' + name);

      var payload = buildPayload(row, userId);

      $.ajax({
        url: api,
        type: 'POST',
        data: payload,
        dataType: 'json',
        timeout: 60000
      }).done(function (res) {
        if (res && res.code === 1) {
          var m3u8 = res.m3u8 || '';
          successLinks.push(m3u8);
          logLine('✅ 成功：' + name + ' -> ' + m3u8);
        } else if (res && (res.exists === 1 || /已生成/.test(String(res.msg || '')))) {
          // 后端强制禁止重复生成：这里按要求“跳过”
          logLine('⏭️ 已生成（跳过）：' + name + '（必须先删除旧链接后才能再生成）');
          if (res && res.m3u8) logLine('    现有链接：' + res.m3u8);
        } else {
          logLine('❌ 失败：' + name + ' -> ' + (res ? (res.msg || '未知错误') : '无响应'));
        }
      }).fail(function (xhr, status) {
        logLine('❌ 请求失败：' + name + ' -> ' + status + ' HTTP ' + (xhr && xhr.status ? xhr.status : ''));
      }).always(function () {
        // 下一项（给 UI 一点喘息）
        setTimeout(function () { next(idx + 1); }, 250);
      });
    }

    next(0);
  };
})();
